function [T3] = htest(r,rboots,sboots,gboots,K2) 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code:  Exercise 7.7(b)
% File: htest.m
%
% Converted from GAUSS code written by Leena Kalliovirta 
% Heteroskedasticity test statistic based on UNIVARIATE quantile 
% residuals (QRs).
%               
% INPUT:     
% r      = the vector of quantile residuals (T * 1).        
% rboots = simulated vector of QRs using estimated model (Tboots * 1).        
% sboots = simulated matrix of scores of QRs using estimated model 
%          (Tboots*k) with k the number of columns of sboots.                                 
% gboots = simulated matrix of derivatives of QRs using estimated 
%          models (Tboots * k).                                   
% K2     = the number of lags used in the heteroskedasticity test. 
%            
% OUTPUT:  
% T3     = scalar value of the test statistic, follows a Chi^{2}(K2) 
%          distribution under H0: no heteroskedasticity in QRs.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
T       = length(r);
Tboots  = length(rboots);
[~,k]   = size(sboots);

warning('off','all')  % Disable all warnings. 
%          Replace 'off' by 'on' to enable
% Warning: Matrix "cov" may be close to singular or badly scaled.
%          Results may be inaccurate. 

cov   = inv((sboots'*sboots)/Tboots);
G3    = zeros(K2,k);
RRR   = zeros(K2,1);
gubts = zeros(Tboots-K2,K2);

for i2=1:K2
  for j=1:k
G3(i2,j) = 2*mean((rboots(K2+1-i2:Tboots-i2).^2-1).* ...
           rboots(K2+1:Tboots).*gboots(K2+1:Tboots,j)+...
           ((rboots(K2+1:Tboots).^2-1).* ... 
           rboots(K2+1-i2:Tboots-i2)).* ...
           gboots(K2+1-i2:Tboots-i2,j))';
RRR(i2)     = mean((r(K2+1:T).^2-1).*(r(K2+1-i2:T-i2).^2-1));
gubts(:,i2) = (rboots(K2+1:Tboots).^2-1).* ...
              (rboots(K2+1-i2:Tboots-i2).^2-1);   
  end
end

Sigma3 = (horzcat(sboots(K2+1:Tboots,:),gubts))'* ... 
         (horzcat(sboots(K2+1:Tboots,:),gubts))/(Tboots-K2);
O3     = [G3*cov, eye(K2)]*Sigma3*[G3*cov, eye(K2)]'; 
T3     = T*(RRR')*inv(O3)*RRR;  % Heteroskedasticity test statistic